/** @file   ComboMeter.cpp
 * @brief   Implementation of ComboMeter class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/08/13 10:50:23 $
 * @author  Tomi Lamminsaari
 */

#include "ComboMeter.h"
#include "Statistics.h"
#include "AnimPlayer.h"
#include "GameAnims.h"
#include "AnimId.h"
#include <allegro.h>


namespace WeWantWar {

const int KComboStartTimerValue = 120;

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
ComboMeter::ComboMeter(Statistics& aStatistics) :
  iComboTimer(-1),
  iComboBonusSoFar(0),
  iStatistics( aStatistics )
{
}


/** Destructor.
 */
ComboMeter::~ComboMeter()
{
}

void ComboMeter::advance( ObjectID::Type aKilledObjectType )
{
  switch ( aKilledObjectType ) {
    case ( ObjectID::TYPE_CARNIVOREALIEN ):
    case ( ObjectID::TYPE_SMALLWORMALIEN ):
    case ( ObjectID::TYPE_WINGEDALIEN ):
    case ( ObjectID::TYPE_PROCTORALIEN ):
    case ( ObjectID::TYPE_MINIGUNALIEN ):
    case ( ObjectID::TYPE_PREDATORALIEN ):
    case ( ObjectID::TYPE_MEDIUMWORMALIEN ):
    case ( ObjectID::TYPE_FLAMERALIEN ):
    case ( ObjectID::TYPE_LIGHTBALLALIEN ):
    case ( ObjectID::TYPE_GUARDIANTANK ):
    case ( ObjectID::TYPE_SENTRYGUN ):
    case ( ObjectID::TYPE_FIGHTER ): {
      iComboTimer = KComboStartTimerValue;
      iComboBonusSoFar += 1;
      break;
    }
  }
}

ComboMeter::ComboLevel ComboMeter::update()
{
  iComboTimer -= 1;
  ComboLevel retLevel = ENoCombo;
  if ( iComboTimer == 0 ) {
    ComboLevel lev = this->currentComboLevel();
    retLevel = lev;
    iStatistics.grantScores( lev * 1000 );
    iComboBonusSoFar = 0;
  } 
  return retLevel;
}

void ComboMeter::redraw( BITMAP* aTargetBitmap )
{

}


ComboMeter::ComboLevel ComboMeter::currentComboLevel() const
{
  if ( iComboBonusSoFar < 3 ) {
    return ENoCombo;
    
  } else if ( iComboBonusSoFar < 5 ) {
    return ETripleKill;
    
  } else if ( iComboBonusSoFar < 9 ) {
    return EButcher;
    
  } else if ( iComboBonusSoFar < 15 ) {
    return ESerialKiller;
    
  } else {
    return EAlienMassacre;
    
  }
}

};  // end of namespace
